<?php

namespace Intergo\ServiceCampaignClient\DataTransferObjects;

class MessageDTO
{
    /** @var int|null */
    public ?int $pendingMessageId = null;

    /** @var string|null */
    public ?string $userId = null;

    /** @var string|null */
    public ?string $userName = null;

    /** @var string|null */
    public ?string $userEmail = null;

    /** @var string|null */
    public ?string $companyWebsite = null;

    /** @var string|null */
    public ?string $companyName = null;

    /** @var string|null */
    public ?string $businessName = null;

    /** @var string|null */
    public ?string $twitter = null;

    /** @var string|null */
    public ?string $facebook = null;

    /** @var string|null */
    public ?string $linkedin = null;

    /** @var string|null */
    public ?string $useCase = null;

    /** @var string|null */
    public ?string $senderID = null;

    /** @var string|null */
    public ?string $trustLevel = null;

    /** @var ?array|[] */
    public ?array $previousMessages = [];

     /** @var ?array|[] */
    public ?array $previousPendingMessages = [];

    /** @var string|null */
    public ?string $trace_id = null;

    /** @var string|null */
    public ?string $messageContent = null;

    /** @var string|null */
    public ?string $reason = null;

    /** @var string|null */
    public ?string $details = null;

    /** @var string|null */
    public ?string $status = null;

    /** @var string|null */
    public ?string $forbiddenKeywords = null;

    /** @var string|null */
    public ?string $listOfRecipients = null;

    /** @var string|null */
    public ?string $numberOfPayments = null;

    /** @var int|null */
    public ?int $cleanCampaignsLast30Days = null;

    /** @var int|null */
    public ?int $paymentsLast60Days = null;

    /** @var int|null */
    public ?int $autoApprovedLast14Days = null;

    /** @var int|null */
    public ?int $autoRejectedLast7Days = null;

    /** @var int|null */
    public ?int $holdsReasonLast7Days = null;

    /** @var int|null */
    public ?int $impersonateWithoutVerify = null;

    /** @var int|null */
    public ?int $autoRejectedLast30Days = null;

    /** @var int|null */
    public ?int $unrelatedDomainsLast14Days = null;

    public function __construct(array $data = [])
    {
        $this->pendingMessageId = $data["pendingMessageId"] ?? null;
        $this->userId = $data["userId"] ?? null;
        $this->userName = $data["userName"] ?? null;
        $this->userEmail = $data["userEmail"] ?? null;
        $this->companyWebsite = $data["companyWebsite"] ?? null;
        $this->companyName = $data["companyName"] ?? null;
        $this->businessName = $data["businessName"] ?? null;
        $this->twitter = $data["twitter"] ?? null;
        $this->facebook = $data["facebook"] ?? null;
        $this->linkedin = $data["linkedin"] ?? null;
        $this->useCase = $data["useCase"] ?? null;
        $this->senderID = $data["senderID"] ?? null;
        $this->trustLevel = $data["trustLevel"] ?? null;
        $this->previousMessages = $data["previousMessages"] ?? [];
        $this->previousPendingMessages = $data["previousPendingMessages"] ?? [];
        $this->trace_id = $data["trace_id"] ?? null;
        $this->messageContent = $data["messageContent"] ?? null;
        $this->reason = $data["reason"] ?? null;
        $this->details = $data["details"] ?? null;
        $this->status = $data["status"] ?? null;
        $this->forbiddenKeywords = $data["forbiddenKeywords"] ?? null;
        $this->listOfRecipients = $data["listOfRecipients"] ?? null;
        $this->numberOfPayments = $data["numberOfPayments"] ?? null;
        $this->cleanCampaignsLast30Days = $data["cleanCampaignsLast30Days"] ?? null;
        $this->paymentsLast60Days = $data["paymentsLast60Days"] ?? null;        
        $this->autoApprovedLast14Days = $data["autoApprovedLast14Days"] ?? null;        
        $this->autoRejectedLast7Days = $data["autoRejectedLast7Days"] ?? null;        
        $this->holdsReasonLast7Days = $data["holdsReasonLast7Days"] ?? null;        
        $this->impersonateWithoutVerify = $data["impersonateWithoutVerify"] ?? null;        
        $this->autoRejectedLast30Days = $data["autoRejectedLast30Days"] ?? null;        
        $this->unrelatedDomainsLast14Days = $data["unrelatedDomainsLast14Days"] ?? null;        
    }

    public function toArray(): array
    {
        return get_object_vars($this);
    }
}