<?php

namespace Intergo\ServiceCampaignClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\ServiceCampaignClient\DataTransferObjects\RuleDTO;
use Intergo\ServiceCampaignClient\ServiceCampaignClient;
use Intergo\ServiceCampaignClient\DataTransferObjects\DecisionLogicDTO;

abstract class AbstractServiceCampaignClient
{
    protected ServiceCampaignClient $client;
    protected $baseUrl;

    public function __construct($baseUrl, $traceId)
    {
        $this->baseUrl = $baseUrl;
        $this->client = new ServiceCampaignClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    // Rules endpoints
    public function getAllRules(): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__);
    }

    public function getRuleById(string $ruleId): BaseResponseInterface
    {
        $urlParams = [
            'ruleId' => $ruleId
        ];
        return $this->execute(__FUNCTION__, $urlParams, []);
    }

    public function createRule(array $ruleData): BaseResponseInterface
    {

        $rule = new RuleDTO($ruleData);

        return $this->execute(__FUNCTION__, [], $rule->toArray());
    }

    public function updateRule(string $ruleId, array $ruleData): BaseResponseInterface
    {
        $urlParams = [
            'ruleId' => $ruleId
        ];

        $rule = new RuleDTO($ruleData);

        return $this->execute(__FUNCTION__, $urlParams, $rule->toArray());
    }

    public function deleteRule(string $ruleId): BaseResponseInterface
    {
        $urlParams = [
            'ruleId' => $ruleId
        ];
        
        return $this->execute(__FUNCTION__, $urlParams, []);
    }

    public function getRulesValidityCheck(array $rulesData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $rulesData);
    }

    public function setRulesBulk(array $rulesData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $rulesData);
    }

    // Decision Logic endpoints
    public function getDecisionLogic(): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__);
    }

    // Requests / message endpoints
    public function getAllRequests(int $page, int $size): BaseResponseInterface
    {
        $bodyParams = [
            'page' => $page,
            'size' => $size
        ];

        return $this->execute(__FUNCTION__, [], $bodyParams);
    }

    public function getRequestById(string $requestId): BaseResponseInterface
    {
        $urlParams = [
            'requestId' => $requestId
        ];
        return $this->execute(__FUNCTION__, $urlParams, []);
    }
}
