<?php

namespace Intergo\Providers;

use Intergo\Providers\MessageManager\SMSManager;
use Illuminate\Support\ServiceProvider;

class SMSServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Register the main class to use with the facade
        $this->app->singleton('sms', function ($app)
        {
            return new SMSManager($app);
        });
        $this->app->singleton(SMSManager::class, function ($app)
        {
            return $app->make('sms');
        });
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['sms'];
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
