<?php

namespace Intergo\Providers\MessageManager;

use Intergo\Providers\MessageManager\Drivers\AlarisDriver;
use Intergo\Providers\MessageManager\Drivers\MstatViberDriver;
use Intergo\Providers\MessageManager\Drivers\RouteeDriver;
use Intergo\Providers\MessageManager\Drivers\RouteeOtpDriver;
use Intergo\Providers\MessageManager\Drivers\RouteeViberDriver;
use Intergo\Providers\MessageManager\Drivers\NthViberDriver;
use Illuminate\Support\Manager;

use function GuzzleHttp\Promise\all;

class SMSManager extends Manager
{

    /**
     * @param $provider
     * @param array $message
     * @return mixed
     */
    public function channel($provider, array $message)
    {
        if (is_string($provider)) {
            $driver = $this->driver($provider);
        } elseif ($provider->slug == "viber") {
            $slug = "viber-" . $message['viber_provider'];
            $driver = $this->driver($slug);
        } else {
            $driver = $this->driver($provider->slug);
        }
        return $driver;
    }

    /**
     * Get the default driver name.
     *
     * @return string
     */
    public function getDefaultDriver()
    {
        return 'routee';
    }

    public function createViberRouteeDriver() : RouteeViberDriver
    {
        return new RouteeViberDriver();
    }

    public function createViberMstatDriver() : MstatViberDriver
    {
        return new MstatViberDriver();
    }

    public function createViberNthDriver() : NthViberDriver
    {
        return new NthViberDriver();
    }

    public function createRouteeDriver(): RouteeDriver
    {
        return new RouteeDriver();
    }

    public function createRouteeOtpDriver(): RouteeOtpDriver
    {
        return new RouteeOtpDriver();
    }

    /**
     * This is to point the Alaris OTP Driver to the correct driver and separate the queue
     * of OTP from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarisOtpDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris OTP Global Driver to the correct driver and separate the queue
     * of OTP from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarisOtgDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris Mock Driver to the correct driver and separate the queue
     * of mock from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarisMockDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris D Driver to the correct driver and separate the queue
     * of d from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarisdDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris DL Driver to the correct driver and separate the queue
     * of dl from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarisdlDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris S Driver to the correct driver and separate the queue
     * of s from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarissDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris W Driver to the correct driver and separate the queue
     * of w from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlariswDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris G Driver to the correct driver and separate the queue
     * of G from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarisgDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * This is to point the Alaris P Driver to the correct driver and separate the queue
     * of P from the actual Alaris provider
     *
     * @return AlarisDriver
     */
    public function createAlarispDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * @return AlarisDriver
     */
    public function createAlarisSs7Driver(): AlarisDriver
    {
        return new AlarisDriver();
    }

    /**
     * @return AlarisDriver
     */
    public function createAlarisWmDriver(): AlarisDriver
    {
        return new AlarisDriver();
    }
}
