<?php

namespace Intergo\Providers\MessageManager\Drivers;

class RouteeDriver extends RouteeSmsDriver
{
    
    public function __construct()
    {
        parent::__construct();
        $this->applicationId = config('services.routee.applicationId');
        $this->secret = config('services.routee.secret');
    }    
    
    /**
     * After sending message provider(provider have different fields in response), I want to map different responses to have standard mapping
     * With this function, I will be getting standardized fields for all providers
     *
     * Routee
     * {@inheritdoc}
     */
    public function mapper(array $resultMessage)
    {
        $resultMessage = parent::mapper($resultMessage);
        $resultMessage['provider'] = 'Routee';
        return $resultMessage;
    }
}
