<?php

namespace Intergo\Providers\Enums;

class BaseEnum
{

    /**
     * Get the class Constants
     * @author Christodoulou Panikos
     * @email christodoulou.panicos@cytanet.com.cy
     * @return array
     */
    public static function getConstants()
    {
        $refl = new \ReflectionClass(static::class);
        return ($refl->getConstants());
    }

    /**
     * Get the Constant field
     * @author Christodoulou Panikos
     * @email christodoulou.panicos@cytanet.com.cy
     * @return string
     */
    public static function getConstantField($value)
    {
        return array_search ($value, self::getConstants());
    }

    /**
     * Get all values of all constants
     * @return array
     */
    public static function getConstantValues()
    {
        return array_values(static::getConstants());
    }

    /**
     * Get the Constant Name
     * @author Christodoulou Panikos
     * @email christodoulou.panicos@cytanet.com.cy
     * @return string
     */
    public static function getConstantName($value)
    {
        return constant(static::class . "::" . $value);
    }

}
