<?php

namespace Intergo\Providers\MessageManager\Drivers;

class RouteeOtpDriver extends RouteeSmsDriver
{
    public function __construct()
    {
        parent::__construct();
        $this->applicationId = config('services.routee_otp.applicationId');
        $this->secret = config('services.routee_otp.secret');
        $this->name = 'Routee';
    }

    /**
     * After sending message provider(provider have different fields in response), I want to map different responses to have standard mapping
     * With this function, I will be getting standardized fields for all providers
     *
     * Routee
     * {@inheritdoc}
     */
    public function mapper(array $resultMessage)
    {
        $resultMessage = parent::mapper($resultMessage);
        $resultMessage['provider'] = 'RouteeOTP';
        return $resultMessage;
    }
}
