<?php

namespace Intergo\ProductsRatesClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class ProductsRatesApiHandler extends ApiHandler
{
    protected static array $endpoints = [

        'listNetworks' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/networks', self::INTERNAL => true],
        'getNetworkById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/networks/:id', self::INTERNAL => true],
        'getNetworkByPhoneNumber' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/networks/:phone_number/lookup', self::INTERNAL => true],

        'listAdjustedRates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/adjusted-rates', self::INTERNAL => true],
        'getAdjustedRateById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/adjusted-rates/:id', self::INTERNAL => true],
        'createAdjustedRate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/adjusted-rates', self::INTERNAL => true],
        'updateAdjustedRate' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/adjusted-rates/:id', self::INTERNAL => true],
        'deleteAdjustedRate' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/adjusted-rates/:id', self::INTERNAL => true],

        'listProducts' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/products', self::INTERNAL => true],
        'getProductById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/products/:id', self::INTERNAL => true],
        'getProductRates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/products/:id/rates', self::INTERNAL => true],
        'updateProduct' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/products/:id', self::INTERNAL => true],
        'syncProducts' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/products/sync', self::INTERNAL => true],

        'listProductTypes' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/product-types', self::INTERNAL => true],
        'getProductTypeById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/product-types/:id', self::INTERNAL => true],
        'createProductType' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/product-types', self::INTERNAL => true],
        'updateProductType' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/product-types/:id', self::INTERNAL => true],
        'deleteProductType' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/product-types/:id', self::INTERNAL => true],

        'getRate' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/rates', self::INTERNAL => true],

        'listUserProducts' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-products', self::INTERNAL => true],
        'getUserProductById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-products/:id', self::INTERNAL => true],
        'createUserProduct' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-products', self::INTERNAL => true],
        'deleteUserProduct' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/user-products/:id', self::INTERNAL => true],
        'createUserProductAndAdjustedRatesForABrand' => [self::METHOD => HttpMethodEnum::POST,self::URL => '/brands', self::INTERNAL => true],
    ];
}
