<?php


use CurrencyExchangerService\ConvertRequest;
use CurrencyExchangerService\ConvertResponse;
use CurrencyExchangerService\ConvertServiceClient;
use Grpc\ChannelCredentials;

class CurrencyConverterClient
{
    /**
     * @param $hostname
     * @param $amount
     * @param $from
     * @param $to
     * @param $precision
     * @return ConvertResponse
     */
    public static function convert($hostname, $amount, $from, $to, $precision = 4): ConvertResponse
    {
        $client = new ConvertServiceClient($hostname, [
            'credentials' => ChannelCredentials::createInsecure(),
        ]);
        list($data, $status) = $client->Convert(new ConvertRequest([
            'amount' => $amount,
            'fromCurrency' => $from,
            'toCurrency' => $to,
            'precision' => $precision,
        ]))->wait();

        return $data;
    }
}
