<?php

namespace Intergo\OptOut\Enums;

class OptOutEnum
{
    const CACHE_CONNECTION = 'cache'; //MSMS cache
    const OPT_OUT_CACHE_KEY = 'OptOutUser';

    const LIST_OPT_OUT = 'listoptout';
    const LIST_ESTIMATE = 'list_estimate';
    const GLOBAL_OPT_OUT = 'globaloptout';

    const OPT_OUT_PLACEHOLDER = '{optout}';

    /**
     * @param $key
     * @return string
     */
    public static function cacheKeyUser($key): string
    {
        return self::OPT_OUT_CACHE_KEY . ":$key";
    }

    /**
     * @param $userId
     * @return string
     */
    public static function getListEstimateHashKey($userId): string
    {
        return "$userId:" . self::LIST_ESTIMATE;
    }

    /**
     * @param $userId
     * @return array
     */
    public static function getUserHashKeys($userId): array
    {
        return [
            self::cacheKeyUser($userId),
            self::cacheKeyUser(self::getListEstimateHashKey($userId))
        ];
    }
}
