<?php

namespace Intergo\MessageClient;

use Intergo\MessageClient\Exceptions\SmstoInvalidSenderIdException;

class SenderIdValidator
{
    const DEFAULT_SENDER_ID = 'SMSTo';

    /**
     * @param $senderId
     * @throws SmstoInvalidSenderIdException
     */
    public static function validateViber($senderId)
    {
        if (!empty($senderId)) {
            // allow + if is rented number
            $pregString = '/^[a-zA-Z0-9-._\s&]+$/i';

            // Sender ID can have only letters, digits and spaces:
            if (!preg_match($pregString, $senderId)) {
                throw new SmstoInvalidSenderIdException('Sender ID can only contain alphanumeric characters and spaces.', 400);
            }

            // it cannot have more than 35 characters:
            if (strlen($senderId) > 35) {
                throw new SmstoInvalidSenderIdException('The Sender ID cannot contain more than 35 characters.', 400);
            }
        } else {
            throw new SmstoInvalidSenderIdException('Empty sender ID.', 400);
        }
    }

    /**
     * @param $senderId
     * @return void
     * @throws SmstoInvalidSenderIdException
     */
    public static function validate($senderId)
    {
        // allow + if is rented number
        $pregString = '/^[a-zA-Z0-9-_\s&]+$/i';
        // Sender ID can have only letters, digits and spaces:
        if (!preg_match($pregString, $senderId)) {
            throw new SmstoInvalidSenderIdException('Sender ID can only contain alphanumeric characters and spaces.', 400);
        }
        // If it has digits only (no letters and spaces) - it cannot have more than 16 digits:
        if (preg_match('/^[0-9]+$/', $senderId) && strlen($senderId) > 16) {
            throw new SmstoInvalidSenderIdException('The numeric Sender ID cannot contain more than 16 digits.',
                                                    400);
        }
        // If it contains letters or spaces - it cannot have more than 11 characters:
        if (preg_match('/[a-z-_\s&]/i', $senderId) && strlen($senderId) > 11) {
            throw new SmstoInvalidSenderIdException('The alphanumeric Sender ID cannot contain more than 11 characters.',
                                                    400);
        }
    }

}