<?php

namespace Intergo\MessageClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class MessageApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'updateUserSettingsV2' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user/:user_id/settings/update', self::INTERNAL => true],
        'updateViberSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user/:user_id/settings/viber/update', self::INTERNAL => true],
        'invalidateUserLists' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user/:user_id/lists/invalidate', self::INTERNAL => true],
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user/:user_id/settings', self::INTERNAL => true],
        'getNetworkByIds' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/network-bulk', self::INTERNAL => true],
        'updateNetwork' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/network/:id/update', self::INTERNAL => true],
        'updateStatusMessageFromProvider' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/manager/message/:message_id/status', self::INTERNAL => true],
        'updateStatusMessageMassFromProvider' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/manager/messages/status', self::INTERNAL_SECURE => true],

        'getCountryRatesAll' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/country-rates', self::INTERNAL => true],
        'getCountryRate' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/country-rates/:id', self::INTERNAL => true],
        'updateCountryRate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/manager/country-rates', self::INTERNAL_SECURE => true],
        'deleteCountryRate' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/manager/country-rates/:id', self::INTERNAL_SECURE => true],

        'getProviderErrorCodes' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/manager/provider-error-codes', self::INTERNAL => true],
        'getProviderErrorCode' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/manager/provider-error-codes/:id', self::INTERNAL => true],
        'createProviderErrorCode' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/manager/provider-error-codes', self::INTERNAL => true],
        'updateProviderErrorCode' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/manager/provider-error-codes/:id', self::INTERNAL => true],
        'deleteProviderErrorCode' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/manager/provider-error-codes/:id', self::INTERNAL => true],

        'getProviderStates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/manager/provider-states', self::INTERNAL => true],
        'getProviderState' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/manager/provider-states/:id', self::INTERNAL => true],
        'createProviderState' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/manager/provider-states', self::INTERNAL => true],
        'updateProviderState' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/manager/provider-states/:id', self::INTERNAL => true],
        'deleteProviderState' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/manager/provider-states/:id', self::INTERNAL => true],
    ];
}
