<?php

namespace Intergo\Log\Middleware;

use Closure;
use Illuminate\Http\Request;
use Intergo\Log\Contracts\LoggingFieldsEnum;
use Intergo\Log\GrayLogHandler;

class LogApiRequest
{
    /**
     * Log incoming request
     *
     * @param Request $request
     * @param Closure $next
     * @param GrayLogHandler $logger
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $data = $request->except('q');
        app(GrayLogHandler::class)->warning("API Request: {$request->method()} {$request->path()}", [
            LoggingFieldsEnum::REQUEST_DATA => $data
        ]);
        return $next($request);
    }
}
