<?php

namespace Intergo\Log\LaravelHelpers\Services;

use Illuminate\Support\Str;
use Intergo\Log\Contracts\LoggingFieldsEnum;
use Intergo\Log\LaravelHelpers\TraceHelper;
use Monolog\LogRecord;

/**
 * Fix messages to graylog of GelfProcessor
 *
 * @author Panayiotis Halouvas <phalouvas@kainotomo.com>
 */
class GelfProcessor
{
    /**
     * Transform a "ID" string record into a "id_smsto" value.
     * Transform a "MESSAGE" string record into a "message_smsto" value.
     *
     * @param LogRecord|array $record
     * @return LogRecord|array
     *
     */
    public function __invoke($record)
    {
        $context = is_array($record) ? $record['context'] : $record->context;

        $traceid_exist = in_array('trace_id', array_keys($context));
        if (!$traceid_exist) {
            $context['trace_id'] = TraceHelper::generateTraceId();
        }

        foreach ($context as $key => $value) {
            if (strtoupper($key) === 'ID') {
                $context['id_' . strtolower(getenv('APP_NAME'))] = $value;
                unset($context[$key]);
            }
            if (strtoupper($key) === 'MESSAGE') {
                $context['message_' . strtolower(getenv('APP_NAME'))] = $value;
                unset($context[$key]);
            }
        }

        $user = $this->getUser();
        if ($user) {
            $context['email'] = $context['email'] ?? $user->email;
            $context[LoggingFieldsEnum::AUTH_USER_ID] = $context[LoggingFieldsEnum::AUTH_USER_ID] ?? $user->id;
        }

        if (is_array($record)) {
            $record['context'] = $context;
            return $record;
        }

        return $record->with(context: $context);
    }

    protected function getUser()
    {
        return null;
    }

}
