<?php

namespace Intergo\Log\Contracts;

class LoggingFieldsEnum extends AbstractEnumContract
{
    # USER/AUTHENTICATION:
    const A2_CODE                  = 'a2_code';
    const API_ID                   = 'api_id';
    const API_KEY                  = 'api_key';
    const AUTH_RESULT              = "auth_result";
    const AUTH_USER_ID             = "auth_user_id";
    const AUTHENTICATION_ATTEMPTS  = "authentication_attempts";
    const AVATAR                   = "avatar";
    const BAN_REASON               = "ban_reason";
    const BUSINESS_ADDRESS         = "business_address";
    const BUSINESS_CITY            = "business_city";
    const BUSINESS_COUNTRY         = "business_country";
    const BUSINESS_POSTAL_CODE     = "business_postal_code";
    const CALLBACK_URL             = 'callback_url';
    const CLIENT_ID                = 'clientId';
    const COUNTRY                  = "country";
    const COUNTRY_IP               = "country_ip";
    const CONFIRM_CODE             = "confirm_code";
    const EMAIL                    = "email";
    const FAILED_AT                = "failed_at";
    const FAIL_STATUS              = "fail_status";
    const FIRST_NAME               = "first_name";
    const FORM_PARAMS              = "form_params";
    const IP_ADDRESS               = "ip";
    const IP                       = "ip";
    const JWT_AUTH_SECRET          = 'jwt_auth_secret';
    const LAST_NAME                = "last_name";
    const NAME                     = "name";
    const PASSWORD                 = "password";
    const PHONE                    = "phone";
    const REFRESHED_TOKEN          = "refreshed_token";
    const REGISTER_RESULT          = "register_result";
    const REQUEST_IP               = "request_ip";
    const RESPONSE_DATA            = "response_data";
    const RESPONSE_MESSAGE         = "response_message";
    const RESPONSE_RULE_CODE       = "responseCode";
    const RESTRICTED_TO_OWN_NUMBER = "restricted_to_own_number"; //@todo: add it to type?
    const RESTORE_HASH             = "restore_hash";
    const RULE                     = "rule";
    const RULE_RESULT              = "rule_result";
    const SECRET                   = 'secret';
    const SEARCH_KEYWORD           = "search_keyword";
    const SENT_AT                  = "sent_at";
    const SERVICE_ID               = "service_id";
    const SERVICE_NAME             = "service_name";
    const SIGNED_PAYLOAD           = "signed_payload";
    const SITE                     = "site";
    const SMS_USER_ID              = "sms_user_id";
    const TEAM_ID                  = "team_id";
    const TITLE                    = "title";
    const TIMEZONE                 = "timezone";
    const TOKEN                    = "token";
    const TWOFA_ATTEMPTS           = 'twofa_attempts';
    const UNVERIFIED_EMAIL         = "unverified_email";
    const UPDATED_BY_AUTH_USER_ID  = "updated_by_auth_user_id";
    const USERNAME                 = "username";
    const DOMAIN                   = "domain";
    const PARAMS                   = "params";

    # LISTS/CONTACTS
    const HAS_USER_LISTS = "has_user_lists";
    const LIST_CONTACTS  = "list_contacts";

    # BALANCE/MONEY:
    const AMOUNT                    = "amount";
    const AMOUNT_IN_EUR             = "amount_in_eur";
    const BALANCE                   = "balance";
    const BILLING_COUNTRY           = "billing_country";
    const BILLING_DETAILS           = "billing_details";
    const COUNT                     = "count";
    const CURRENCY                  = "currency";
    const ESCROW_BALANCE            = "escrow_balance";
    const FORMATTED_TOTAL           = "formatted_total";
    const GATEWAY_FEE               = "gateway_fee";
    const GATEWAY_FEE_IN_EUR        = "gateway_fee_in_eur";
    const GATEWAY_IDENTIFIER        = "gateway_identifier";
    const INTERVAL                  = "interval";
    const NEW_BALANCE               = "new_balance";
    const NEW_DB_BALANCE            = "new_db_balance";
    const NEW_ESCROW_BALANCE        = "new_escrow_balance";
    const OLD_BALANCE               = "old_balance";
    const OLD_BALANCE_AFTER_CHANGE  = "old_balance_after_change";
    const OLD_BALANCE_BEFORE_CHANGE = "old_balance_before_change";
    const OLD_ESCROW_BALANCE        = "old_escrow_balance";
    const PAYMENT_ID                = "payment_id";
    const PAYMENT_METHOD            = "payment_method";
    const PAYMENT_METHOD_ID         = "payment_method_id";
    const PAYOUT_AMOUNT             = "payout_amount";
    const PAYOUT_ID                 = "payout_id";
    const PROFORMA_INVOICE_NUMBER   = "proforma_invoice_number";
    const REFUND_AMOUNT             = "refund_amount";
    const REFUND_DATE               = "refund_date";
    const REMARKS                   = "remarks";
    const STATUS                    = "status";
    const TOTAL                     = "total";
    const VAT                       = "vat";
    const VAT_IN_EUR                = "vat_in_eur";

    # JCC
    const ACQUIRER_ID                = "acquirerID";
    const ACQ_ID                     = "AcqID";
    const CAPTURE_FLAG               = "CaptureFlag";
    const EXPECTED_SIGNATURE         = "expectedSignature";
    const MERCHANT_ID                = "merchantID";
    const MER_ID                     = "MerID";
    const MER_RESP_URL               = "MerRespURL";
    const MER_CALLBACK_URL           = "MerCallbackURL";
    const ORDER_ID                   = "OrderID";
    const PURCHASE_AMT               = "PurchaseAmt";
    const PURCHASE_CURRENCY          = "PurchaseCurrency";
    const PURCHASE_CURRENCY_EXPONENT = "PurchaseCurrencyExponent";
    const REASON_CODE                = "reasonCode";
    const RESPONSE_CODE              = "responseCode";
    const RESPONSE_SIGNATURE         = "responseSignature";
    const SIGNATURE                  = "Signature";
    const SIGNATURE_METHOD           = "SignatureMethod";

    # STRIPE
    const STRIPE_EVENT_ID              = "stripe_event_id";
    const STRIPE_EVENT_CREATED         = "stripe_event_created";
    const STRIPE_PAYMENT_INTENT_ID     = "stripe_payment_intent_id";
    const STRIPE_REFUND_STATUS         = "stripe_refund_status";
    const STRIPE_REFUND_FAILURE_REASON = "stripe_refund_failure_reason";

    # ROUTEE
    const RESPONSE_ROUTEE_CODE = "responseRouteeCode";

    # PAYPAL (most are uppercase)
    const ACK           = 'ACK';
    const ACTION        = 'action';
    const AMT           = 'AMT';
    const BUILD         = 'BUILD';
    const CORRELATIONID = 'CORRELATIONID';
    const DATA          = 'data';
    const DESC          = 'DESC';
    const DESCRIPTION   = 'description';
    const INVNUM        = 'INVNUM';
    const PAYPAL_LINK   = 'paypal_link';
    const PAYPAL_TOKEN  = 'PAYPAL_TOKEN';
    const VERSION       = 'VERSION';

    # AUTO-RECHARGE
    const APPLYING                   = 'applying';
    const PAYMENT_METHOD_SLUG        = 'payment_method_slug';
    const RECHARGE_AMOUNT            = 'recharge_amount';
    const RECHARGE_TRIGGER_ID        = 'recharge_trigger_id';
    const SECURITY_LIMIT             = 'security_limit';
    const TOTAL_AUTORECHARGES_AMOUNT = 'totalAutoRechargesAmount';

    ## JCC FIELDS
    const JCC_BILLING_ADDRESS      = "billAddress1";
    const JCC_BILLING_CITY         = "billCity";
    const JCC_BILLING_COUNTRY_CODE = "billCountry";
    const JCC_BILLING_EMAIL        = "billEmail";
    const JCC_BILLING_FIRSTNAME    = "billFirstName";
    const JCC_BILLING_LAST_NAME    = "billLastName";
    const JCC_BILLING_PHONE        = "billMobilePhone";
    const JCC_BILLING_POSTCODE     = "billPostalCode";

    # API GENERAL LOGGING FIELDS
    const DEVELOPER_MESSAGE = 'developerMessage';
    const METHOD            = 'method';
    const PATH              = 'path';
    const PAYLOAD           = 'payload';
    const HEADERS           = 'headers';
    const RESULT            = 'result';
    const START_DATE        = 'StartDate';
    const END_DATE          = 'EndDate';

    # FRESHSALES
    const ADDRESS              = 'address';
    const CITY                 = 'city';
    const COMPANY              = 'company';
    const CONTACT_EMAIL        = 'contact_email';
    const CONTACT_ID           = 'contact_id';
    const CONTACT_OWNER_EMAIL  = 'contact_owner_email';
    const CUSTOM_FIELD         = 'custom_field';
    const DEALDATA             = 'dealdata';
    const DEAL_ID              = 'deal_id';
    const FS_OWNER_ID          = 'fs_owner_id';
    const LEAD_EMAIL           = 'lead_email';
    const LEAD_ID              = 'lead_id';
    const LEAD_OWNER_EMAIL     = 'lead_owner_email';
    const MEDIUM               = 'medium';
    const MOBILE_NUMBER        = 'mobile_number';
    const TAGS                 = 'tags';
    const ZIPCODE              = 'zipcode';
    const FS_EXCEPTION_MESSAGE = 'fs_exception_message';
    const FS_PAYLOAD           = 'fs_payload';
    const FAILED_CRM_JOB_ID    = 'failed_crm_job_id';

    # FRESHDESK
    const FRESHDESK_COMPANY_ID = 'freshdesk_company_id';
    const FRESHDESK_CONTACT_ID = 'freshdesk_contact_id';
    const UNIQUE_EXTERNAL_ID   = 'unique_external_id';

    # MESSAGING / ESTIMATION
    const BLOCKED_CALLBACK_URL       = "blocked_callback_url";
    const CALLBACK_RECEIVED_DURATION = "callback_received_duration";
    const CALLBACK_RECEIVED_TIME     = "callback_received_time";
    const CAMPAIGN_ID                = "campaign_id";
    const CLIENT_COST                = "client_cost";
    const CLIENT_COST_IN_EUR         = "client_cost_in_eur";
    const CLIENT_TOTAL_COST          = "client_total_cost";
    const CLIENT_TOTAL_COST_IN_EUR   = "client_total_cost_in_eur";
    const CONTACTS                   = 'contacts';
    const DATE                       = "date";
    const DEFAULT_PREFIX             = 'default_prefix';
    const DELIVERED_MESSAGES         = "delivered_messages";
    const DRIVER                     = "driver";
    const ERROR                      = 'error';
    const ESTIMATED_COST             = 'estimatedCost';
    const FAILED_MESSAGES            = "failed_messages";
    const FAILED_REASON              = "failed_reason";
    const FLASH_SMS                  = 'flash_sms';
    const FINALIZED_SEND_JOB_TIME    = "finalized_send_job_time";
    const ID_STATE                   = "id_state";
    const INTERNAL_FAILED_REASON     = "internal_failed_reason";
    const INTERNAL_MESSAGE_ID        = "internal_message_id"; //this is our _id on messages table
    const LIST_ID                    = "list_id";
    const MESSAGES_COUNT             = "messages_count";
    const MESSAGE_BODY               = "message_body";
    const MESSAGE_ID                 = "message_id"; //this is from provider message_id eg. ITSMPP returns id_state which we need to save it on Graylog on message_id field
    const MESSAGE_PARTS              = "message_parts";
    const MESSAGE_SMSTO              = 'message_smsto';
    const MESSAGE_TYPE               = 'message_type';
    const NETWORK_ID                 = 'network_id';
    const NETWORK_NAME               = "network_name";
    const NOSMS_DOMAIN               = 'nosms_domain';
    const OPERATOR                   = "operator";
    const OUR_COST                   = "our_cost";
    const OUR_TOTAL_COST             = "our_total_cost";
    const OUR_TOTAL_COST_IN_EUR      = "our_total_cost_in_eur";
    const PENDING_MESSAGES           = "pending_messages";
    const PRIORITY                   = "priority";
    const PROVIDER_CHANNEL           = "provider_channel";
    const PROVIDER_ID                = "provider_id";
    const PROVIDER_NAME              = "provider_name";
    const RECEIVED_LIST_IDS          = "received_list_ids";
    const RECEIVED_REQUEST_TIME      = "received_request_time";
    const REJECTED_ERROR_TYPE        = "rejected_error_type";
    const REQUEST_CYCLE_DURATION     = "request_cycle_duration";
    const RESPONSE                   = "response";
    const SENDER_ID                  = 'sender_id';
    const SEND_JOB_TIME              = "send_job_time";
    const SHORTLINK_CODE             = "shortlink_code";
    const SINGLE_CONTACT             = 'single_contact';
    const SMS_COUNT                  = 'smsCount';
    const STATE                      = "state";
    const TO                         = "to";
    const TOTAL_MESSAGES             = 'totalMessages';
    const TRACKING_ID                = "tracking_id";
    const UNSUBSCRIBED_MESSAGES      = "unsubscribed_messages";
    const USER_LISTS                 = 'user_lists';

    # MAIL/SMS NOTIFICATIONS
    const FILENAME = "filename";

    # SENDY
    const SENDY_LIST_ID  = 'sendy_list_id';
    const SENDY_ACTION   = 'sendy_action';
    const SENDY_RESPONSE = 'sendy_response';
    const SENDY_SUCCESS  = 'sendy_success';

    # APOLLO.IO


    # SHORTLINKS
    const SHORTLINK_ID = 'shortlink_id';
    const URL          = 'url';

    # SUBSCRIPTIONS/INBOUND SMS
    const REASON          = 'reason';
    const SUBSCRIPTION_ID = 'subscription_id';

    # AFFILIATE
    const EMAILS_SENT    = "emails_sent";
    const SENDER_EMAIL   = "sender_email";
    const SENDER_USER_ID = "sender_user_id";

    # OPTOUT
    const URL_CODE = 'url_code';

    # ADMIN ACTIVITIES
    const ACTION_BY_CITY    = 'action_by_city';
    const ACTION_BY_COUNTRY = 'action_by_country';
    const ACTION_BY_EMAIL   = 'action_by_email';
    const ACTION_BY_IP      = 'action_by_ip';
    const ACTION_BY_USER_ID = 'action_by_user_id';
    const ACTION_TO_USER    = 'action_to_user';
    const EVENT             = 'event';

    # SUPERVISOR
    const QUEUE_ERROR  = 'queue_error';
    const QUEUE_NAME   = 'queue_name';
    const QUEUE_STATUS = 'queue_status';
    const TAG          = 'tag';

    # ERROR EXCEPTIONS:
    const EXCEPTION_MESSAGE    = 'exception_message';
    const EXCEPTION_TRACE      = 'exception_trace';
    const STRIPE_ERROR_CODE    = 'stripe_error_code';
    const STRIPE_ERROR_MESSAGE = 'stripe_error_message';
    const STRIPE_ERROR_DOC_URL = 'STRIPE_ERROR_DOC_URL';

    # SETTING FIELDS
    const USER_SETTING_BILLING_TYPE         = 'user_setting_billing_type';
    const USER_SETTING_CALLBACK_URL         = 'user_setting_callback_url';
    const USER_SETTING_DEFAULT_PREFIX       = 'user_setting_default_prefix';
    const USER_SETTING_DISABLE_TRANSCODE    = 'user_setting_disable_transcode';
    const USER_SETTING_FLASH_SMS            = 'user_setting_flash_sms';
    const USER_SETTING_MAXIMUM_SMS_PART     = 'user_setting_maximum_sms_parts';
    const USER_SETTING_RESTRICTED_COUNTRIES = 'user_setting_restricted_countries';
    const USER_SETTING_SENDER_ID            = 'user_setting_sender_id';
    const USER_METAS_ID                     = 'user_metas_id';

    # VALIDATION
    const FAILED_VALIDATION_ERRORS = 'validation_errors';
    const FAILED_VALIDATION_URL    = 'failed_validation_url';

    #ROUTEE
    const APPLICATION_NAME    = "applicationName";
    const DIRECTION           = "direction";
    const ORIGINATING_SERVICE = "originatingService";
    const FROM                = 'from';

    #VIBER MESSAGING
    const CAMPAIGN_TRACKING_ID      = "campaignTrackingId";
    const CHANNEL                   = "channel";
    const CORRELATED_MESSAGE_ID     = "correlatedMessageId";
    const CORRELATED_TRANSACTION_ID = "correlatedTransactionId";
    const RECEIVER                  = "receiver";
    const TEXT                      = "text";
    const TIME                      = "time";
    const TRANSACTION_ID            = "transactionId";
    const VIBER_TIME                = "viber_time";

    # HTTP CLIENT REQUEST/RESPONSE:
    const REQUEST_DATA         = 'request_data';
    const REQUEST_METHOD       = 'request_method';
    const REQUEST_URL          = 'request_url';
    const RESPONSE_BODY        = 'response_body';
    const RESPONSE_REASON      = 'response_reason';
    const RESPONSE_STATUS_CODE = 'response_status_code';

    # EXPORT
    const MESSAGE_FILENAME = "message_filename";

    protected static function getIntegerFields(): array
    {
        return array_merge(parent::getIntegerFields(), [
            self::ACQUIRER_ID,
            self::ACQ_ID,
            self::ACTION_BY_USER_ID,
            self::API_ID,
            self::APPLYING,
            self::AUTHENTICATION_ATTEMPTS,
            self::AUTH_USER_ID,
            self::BUILD,
            self::CONTACT_ID,
            self::DEAL_ID,
            self::DELIVERED_MESSAGES,
            self::EMAILS_SENT,
            self::FAILED_CRM_JOB_ID,
            self::FAILED_MESSAGES,
            self::FRESHDESK_COMPANY_ID,
            self::FRESHDESK_CONTACT_ID,
            self::FS_OWNER_ID,
            self::HAS_USER_LISTS,
            self::JCC_BILLING_COUNTRY_CODE,
            self::LEAD_ID,
            self::MERCHANT_ID,
            self::MER_ID,
            self::MESSAGES_COUNT,
            self::MESSAGE_PARTS,
            self::NETWORK_ID,
            self::PAYMENT_ID,
            self::PAYMENT_METHOD_ID,
            self::PAYOUT_ID,
            self::PENDING_MESSAGES,
            self::PRIORITY,
            self::PROVIDER_ID,
            self::PURCHASE_CURRENCY,
            self::PURCHASE_CURRENCY_EXPONENT,
            self::REASON_CODE,
            self::RECHARGE_TRIGGER_ID,
            self::RESPONSE_CODE,
            self::RESPONSE_ROUTEE_CODE,
            self::RESPONSE_RULE_CODE,
            self::RESPONSE_STATUS_CODE,
            self::SENDER_USER_ID,
            self::SERVICE_ID,
            self::SHORTLINK_ID,
            self::SMS_COUNT,
            self::SMS_USER_ID,
            self::STRIPE_ERROR_CODE,
            self::STRIPE_EVENT_ID,
            self::STRIPE_PAYMENT_INTENT_ID,
            self::SUBSCRIPTION_ID,
            self::TEAM_ID,
            self::TOTAL_MESSAGES,
            self::TWOFA_ATTEMPTS,
            self::UNIQUE_EXTERNAL_ID,
            self::UNSUBSCRIBED_MESSAGES,
            self::UPDATED_BY_AUTH_USER_ID,
            self::USER_METAS_ID,
            self::USER_SETTING_DISABLE_TRANSCODE,
            self::USER_SETTING_MAXIMUM_SMS_PART,
        ]);
    }

    protected static function getFloatFields(): array
    {
        return array_merge(parent::getFloatFields(), [
            self::AMOUNT,
            self::AMOUNT_IN_EUR,
            self::AMT,
            self::BALANCE,
            self::CALLBACK_RECEIVED_DURATION,
            self::CALLBACK_RECEIVED_TIME,
            self::CLIENT_COST,
            self::CLIENT_COST_IN_EUR,
            self::CLIENT_TOTAL_COST,
            self::CLIENT_TOTAL_COST_IN_EUR,
            self::ESCROW_BALANCE,
            self::ESTIMATED_COST,
            self::FINALIZED_SEND_JOB_TIME,
            self::FORMATTED_TOTAL,
            self::GATEWAY_FEE,
            self::GATEWAY_FEE_IN_EUR,
            self::NEW_BALANCE,
            self::NEW_DB_BALANCE,
            self::NEW_ESCROW_BALANCE,
            self::OLD_BALANCE,
            self::OLD_BALANCE_AFTER_CHANGE,
            self::OLD_BALANCE_BEFORE_CHANGE,
            self::OLD_ESCROW_BALANCE,
            self::OUR_COST,
            self::OUR_TOTAL_COST,
            self::OUR_TOTAL_COST_IN_EUR,
            self::PAYOUT_AMOUNT,
            self::RECHARGE_AMOUNT,
            self::REFUND_AMOUNT,
            self::REQUEST_CYCLE_DURATION,
            self::SECURITY_LIMIT,
            self::TOTAL,
            self::TOTAL_AUTORECHARGES_AMOUNT,
            self::VAT,
            self::VAT_IN_EUR,
        ]);
    }

    protected static function getStringFields(): array
    {
        return array_merge(parent::getStringFields(), [
            self::A2_CODE,
            self::ACK,
            self::ACTION,
            self::ACTION_BY_CITY,
            self::ACTION_BY_COUNTRY,
            self::ACTION_BY_EMAIL,
            self::ACTION_BY_IP,
            self::ACTION_TO_USER,
            self::ADDRESS,
            self::API_KEY,
            self::APPLICATION_NAME,
            self::AUTH_RESULT,
            self::AVATAR,
            self::BAN_REASON,
            self::BILLING_COUNTRY,
            self::BILLING_DETAILS,
            self::BLOCKED_CALLBACK_URL,
            self::BUSINESS_ADDRESS,
            self::BUSINESS_CITY,
            self::BUSINESS_COUNTRY,
            self::BUSINESS_POSTAL_CODE,
            self::CALLBACK_URL,
            self::CAMPAIGN_ID,
            self::CAMPAIGN_TRACKING_ID,
            self::CAPTURE_FLAG,
            self::CHANNEL,
            self::CITY,
            self::CLIENT_ID,
            self::COMPANY,
            self::CONFIRM_CODE,
            self::CONTACTS,
            self::CONTACT_EMAIL,
            self::CONTACT_OWNER_EMAIL,
            self::CORRELATED_MESSAGE_ID,
            self::CORRELATED_TRANSACTION_ID,
            self::CORRELATIONID,
            self::COUNTRY,
            self::COUNTRY_IP,
            self::CUSTOM_FIELD,
            self::CURRENCY,
            self::DATA,
            self::DATE,
            self::DEALDATA,
            self::DEFAULT_PREFIX,
            self::DESC,
            self::DESCRIPTION,
            self::DEVELOPER_MESSAGE,
            self::DIRECTION,
            self::DRIVER,
            self::EMAIL,
            self::END_DATE,
            self::ERROR,
            self::EVENT,
            self::EXCEPTION_MESSAGE,
            self::EXCEPTION_TRACE,
            self::EXPECTED_SIGNATURE,
            self::FAILED_AT,
            self::FAILED_REASON,
            self::FAILED_VALIDATION_URL,
            self::FAIL_STATUS,
            self::FILENAME,
            self::FIRST_NAME,
            self::FLASH_SMS,
            self::FORM_PARAMS,
            self::FROM,
            self::FS_EXCEPTION_MESSAGE,
            self::FS_PAYLOAD,
            self::GATEWAY_IDENTIFIER,
            self::HEADERS,
            self::ID_STATE,
            self::INTERNAL_FAILED_REASON,
            self::INTERNAL_MESSAGE_ID,
            self::INTERVAL,
            self::INVNUM,
            self::IP,
            self::IP_ADDRESS,
            self::JCC_BILLING_ADDRESS,
            self::JCC_BILLING_CITY,
            self::JCC_BILLING_EMAIL,
            self::JCC_BILLING_FIRSTNAME,
            self::JCC_BILLING_LAST_NAME,
            self::JCC_BILLING_PHONE,
            self::JCC_BILLING_POSTCODE,
            self::JWT_AUTH_SECRET,
            self::LAST_NAME,
            self::LEAD_EMAIL,
            self::LEAD_OWNER_EMAIL,
            self::LIST_CONTACTS,
            self::LIST_ID,
            self::MEDIUM,
            self::MER_CALLBACK_URL,
            self::MER_RESP_URL,
            self::MESSAGE_BODY,
            self::MESSAGE_FILENAME,
            self::MESSAGE_ID,
            self::MESSAGE_SMSTO,
            self::MESSAGE_TYPE,
            self::METHOD,
            self::MOBILE_NUMBER,
            self::NAME,
            self::NETWORK_NAME,
            self::NOSMS_DOMAIN,
            self::OPERATOR,
            self::ORDER_ID,
            self::ORIGINATING_SERVICE,
            self::PARAMS,
            self::PASSWORD,
            self::PATH,
            self::PAYLOAD,
            self::PAYMENT_METHOD,
            self::PAYMENT_METHOD_SLUG,
            self::PAYPAL_LINK,
            self::PHONE,
            self::PROFORMA_INVOICE_NUMBER,
            self::PROVIDER_NAME,
            self::PROVIDER_CHANNEL,
            self::PURCHASE_AMT,
            self::QUEUE_ERROR,
            self::QUEUE_NAME,
            self::QUEUE_STATUS,
            self::REASON,
            self::RECEIVED_LIST_IDS,
            self::RECEIVED_REQUEST_TIME,
            self::RECEIVER,
            self::REFRESHED_TOKEN,
            self::REFUND_DATE,
            self::REGISTER_RESULT,
            self::REJECTED_ERROR_TYPE,
            self::REMARKS,
            self::REQUEST_DATA,
            self::REQUEST_IP,
            self::REQUEST_METHOD,
            self::REQUEST_URL,
            self::RESPONSE,
            self::RESPONSE_BODY,
            self::RESPONSE_DATA,
            self::RESPONSE_MESSAGE,
            self::RESPONSE_REASON,
            self::RESPONSE_SIGNATURE,
            self::RESTORE_HASH,
            self::RESULT,
            self::RULE,
            self::RULE_RESULT,
            self::SEARCH_KEYWORD,
            self::SECRET,
            self::SENDER_EMAIL,
            self::SENDER_ID,
            self::SENDY_ACTION,
            self::SENDY_LIST_ID,
            self::SENDY_RESPONSE,
            self::SEND_JOB_TIME,
            self::SENT_AT,
            self::SERVICE_NAME,
            self::SHORTLINK_CODE,
            self::SIGNATURE,
            self::SIGNATURE_METHOD,
            self::SIGNED_PAYLOAD,
            self::SINGLE_CONTACT,
            self::SITE,
            self::START_DATE,
            self::STATE,
            self::STATUS,
            self::STRIPE_ERROR_DOC_URL,
            self::STRIPE_ERROR_MESSAGE,
            self::STRIPE_EVENT_CREATED,
            self::STRIPE_REFUND_FAILURE_REASON,
            self::STRIPE_REFUND_STATUS,
            self::TAG,
            self::TAGS,
            self::TEXT,
            self::TIME,
            self::TIMEZONE,
            self::TITLE,
            self::TO,
            self::TOKEN,
            self::TRACKING_ID,
            self::TRANSACTION_ID,
            self::UNVERIFIED_EMAIL,
            self::URL,
            self::URL_CODE,
            self::USERNAME,
            self::USER_LISTS,
            self::USER_SETTING_BILLING_TYPE,
            self::USER_SETTING_CALLBACK_URL,
            self::USER_SETTING_DEFAULT_PREFIX,
            self::USER_SETTING_FLASH_SMS,
            self::USER_SETTING_RESTRICTED_COUNTRIES,
            self::USER_SETTING_SENDER_ID,
            self::VERSION,
            self::VIBER_TIME,
            self::ZIPCODE,
        ]);
    }

    protected static function getBooleanFields(): array
    {
        return array_merge(parent::getBooleanFields(), [
            self::RESTRICTED_TO_OWN_NUMBER,
            self::SENDY_SUCCESS
        ]);
    }

    protected static function getMappingFields(): array
    {
        return array_merge(parent::getMappingFields(), [
            'TOKEN'               => self::PAYPAL_TOKEN,
            'Version'             => self::VERSION,
            '_id'                 => self::INTERNAL_MESSAGE_ID,
            '_id_smsto'           => self::INTERNAL_MESSAGE_ID,
            'authenticate_result' => self::AUTH_RESULT,
            'cashBalance'         => self::BALANCE,
            'formattedTotal'      => self::FORMATTED_TOTAL,
            'gatewayFeeAmount'    => self::GATEWAY_FEE,
            'login_result'        => self::AUTH_RESULT,
            'message'             => self::MESSAGE_BODY,
            'messageId'           => self::MESSAGE_ID,
            'message_Id'          => self::MESSAGE_ID,
            'message_smsto'       => self::INTERNAL_MESSAGE_ID,
            'message_user_id'     => self::AUTH_USER_ID,
            'number'              => self::PHONE,
            'orderID'             => self::ORDER_ID,
            'organization_name'   => self::COMPANY,
            'our_message_id'      => self::INTERNAL_MESSAGE_ID,
            'parts'               => self::MESSAGE_PARTS,
            'phone'               => self::TO,
            'phoneNumber'         => self::TO,
            'price'               => self::CLIENT_COST,
            'provider'            => self::PROVIDER_NAME,
            'refreshedToken'      => self::REFRESHED_TOKEN,
            'serviceName'         => self::SERVICE_NAME,
            'smsId'               => self::MESSAGE_ID,
            'sms_count'           => self::MESSAGES_COUNT,
            'teamId'              => self::TEAM_ID,
            'trackingId'          => self::TRACKING_ID,
            'type'                => self::MESSAGE_TYPE,
            'userId'              => self::SMS_USER_ID,
            'user_Id'             => self::SMS_USER_ID,
            'user_email'          => self::EMAIL,
            'user_id'             => self::SMS_USER_ID,
            'user_remote'         => self::AUTH_USER_ID,
            'user_remote_id'      => self::AUTH_USER_ID,
            'vatAmount'           => self::VAT,
        ]);
    }
}

