<?php

namespace Intergo\Log\LaravelHelpers\Providers;

use Illuminate\Support\ServiceProvider;
use Intergo\Log\Contracts\LoggingFieldsEnum;
use Intergo\Log\GrayLogHandler;
use Intergo\Log\LaravelHelpers\TraceHelper;
use Psr\Log\LoggerInterface;

class GraylogServiceProvider extends ServiceProvider
{
    protected static string $LoggingFieldsClassName = LoggingFieldsEnum::class;

    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(GrayLogHandler::class, function ($app)
        {
            $trace_id = $app->request->header('X-TRACE-ID');
            if (empty($trace_id)) {
                $trace_id = TraceHelper::generateTraceId();
            }
            $gray_logger_handler = new GrayLogHandler(
                $app->make(LoggerInterface::class),
                static::$LoggingFieldsClassName
            );
            $gray_logger_handler->setTraceId($trace_id);
            return $gray_logger_handler;
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
