<?php

namespace Intergo\LaravelAuthMiddleware\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Intergo\AuthClient\Enums\PermissionEnum;

class AuthUser extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * @param $permissions
     * @return bool
     */
    public function hasAnyPermission($permissions): bool
    {
        foreach ($permissions as $permission) {
            if (in_array($permission, $this->permission)) {
                return true;
            }
        }
        return false;
    }

    /**
     * @return bool
     */
    public function isIntergoEmployee():bool {
        return in_array(PermissionEnum::ACCESS_MANAGER_AREA, $this->permission);
    }
}
