<?php

namespace Intergo\LaravelAuthMiddleware\Listeners;

use Intergo\LaravelAuthMiddleware\Events\UserLoggedIn;
use Illuminate\Support\Facades\Session;
use Intergo\LaravelAuthMiddleware\Services\Microservices\AuthService;

class UserStoreJWT
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Handle the event.
     *
     * @param UserLoggedIn $event
     * @return void
     */
    public function handle(UserLoggedIn $event)
    {
        Session::put(AuthService::SESSION_JWT_TOKEN, $event->authToken);
        if (isset($event->authUser)) {
            Session::put(AuthService::SESSION_AUTH_USER, $event->authUser);
        }
    }
}
