<?php

namespace Intergo\LaravelAuthMiddleware\Http\Middleware\Api;

use Closure;
use Exception;
use App\Models\User;
use Intergo\LaravelAuthMiddleware\Traits\ResponseTrait;

class CheckPermissionApi
{
    use ResponseTrait;

    /**
     * Handle the incoming request.
     *
     * @param $request
     * @param Closure $next
     * @param string $params
     * @return mixed
     * @throws Exception
     */
    public function handle($request, Closure $next, string $params = '')
    {
        $permissions = array_unique(array_filter(array_map('trim', explode('|', $params))));
        $user = $request->user;
        foreach ($permissions as $permission) {
            if ($user->checkPermission($permission)) {
                return $next($request);
            }
        }
        return $this->failed("Access Denied. You do not have permission to {$params}.");
    }
}
