<?php

namespace Intergo\LaravelAuthMiddleware\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UserLoggedIn
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public string $authToken;
    public array $authUser;
    /**
     * Create a new event instance.
     */
    public function __construct(string $authToken, array $authUser)
    {
        $this->authToken = $authToken;
        $this->authUser = $authUser;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array<int, \Illuminate\Broadcasting\Channel>
     */
    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('authentication-channel'),
        ];
    }
}
