<?php

namespace Intergo\LaravelAuthMiddleware;

use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Intergo\LaravelAuthMiddleware\Events\UserLoggedIn;
use Intergo\LaravelAuthMiddleware\Listeners\UserStoreJWT;
use Intergo\LaravelAuthMiddleware\Services\Microservices\AuthService;
use Intergo\Log\Contracts\LoggingFieldsEnum;
use Intergo\Log\GrayLogHandler;
use Psr\Log\LoggerInterface;
use Str;

class LaravelAuthMiddlewareServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(AuthService::class, function () {
            return new AuthService();
        });

        $this->app->singleton(GrayLogHandler::class, function ($app) {
            $trace_id = $app->request->header('X-TRACE-ID');
            if(empty($trace_id)){
                $trace_id = Str::random(32);
            }
            $gray_logger_handler = new GrayLogHandler($app->make(LoggerInterface::class), LoggingFieldsEnum::class);
            $gray_logger_handler->setTraceId($trace_id);
            return $gray_logger_handler;
        });
    }

    /**
     * Bootstrap services.
     * @throws BindingResolutionException
     */
    public function boot(): void
    {
        $this->publishes([
            __DIR__.'/../config/auth-middleware.php' => config_path('auth-middleware.php'),
        ], 'auth-middleware-config');

        Event::listen(
            UserLoggedIn::class,
            [UserStoreJWT::class, 'handle']
        );
    }
}
