<?php

namespace Intergo\LaravelAuthMiddleware\Http\Middleware\Api;

use App\Models\User;
use Illuminate\Support\Facades\Auth;

/**
 * Purpose: Authenticate Api tokens on services.
 *
 * Used by services that support Auth Facade.
 */
class AuthenticateUserApi extends AuthenticateApi
{
    /**
     * @param $user
     * @return void
     */
    protected function loginUser($user)
    {
        $user['_id'] = $user['id'];
        $userCollection = User::hydrate(["user" => $user]);
        $user = $userCollection->first();
        Auth::login($user);
    }
}
