<?php
declare(strict_types=1);

namespace Intergo\LaravelAuthMiddleware\Http\Middleware\Web;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\LaravelAuthMiddleware\Http\Middleware\AbstractAuthMiddleware;
use Intergo\LaravelAuthMiddleware\Models\AuthUser;
use Intergo\LaravelAuthMiddleware\Services\Microservices\AuthService;
use Intergo\LaravelAuthMiddleware\Traits\ResponseTrait;

/**
 * Purpose: Authenticate Web tokens.
 *
 * Used by Web applications.
 */
class AuthenticateWeb extends AbstractAuthMiddleware
{
    use ResponseTrait;

    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @param string $params
     * @return mixed
     */
    public function handle(Request $request, Closure $next, string $params = '')
    {
        $result = parent::handle($request, $next);
        if (!$result->isSuccessful()) {
            return redirect(route('login'));
        }
        return $next($this->request);
    }

    /**
     * @return string|null
     */
    protected function getToken()
    {
        return Session::get(AuthService::SESSION_JWT_TOKEN) ?? $this->request->bearerToken() ?? $this->request->api_key;
    }

    /**
     * @param string $token
     * @param string $ip
     * @return BaseResponseInterface
     */
    protected function authenticate(string $token, string $ip)
    {
        return app(AuthService::class)->authenticateWeb($token, $ip);
    }

    /**
     * @param $user
     * @return void
     */
    protected function loginUser($user)
    {
        $user['_id'] = $user['id'];
        $userCollection = AuthUser::hydrate(["user" => $user]);
        $user = $userCollection->first();
        Auth::login($user);
    }
}

