<?php

declare(strict_types=1);

namespace Intergo\LaravelAuthMiddleware\Http\Middleware\Api;

use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\LaravelAuthMiddleware\Services\Microservices\AuthService;

/**
 * Purpose: Authenticate Web tokens on services.
 *
 * Used by microservices that don't have a session
 * and have Manager routes which need Web token authentication.
 */
class AuthenticateServiceWeb extends AuthenticateApi
{
    /**
     * @param string $token
     * @param string $ip
     * @return BaseResponseInterface
     */
    protected function authenticate(string $token, string $ip)
    {
        return app(AuthService::class)
            ->setCredentials(config('auth-middleware.web_site'), config('auth-middleware.web_site_secret'))
            ->authenticateServiceWeb($token, $ip);
    }
}

