<?php

namespace Intergo\LaravelAuthMiddleware\Traits;

use App\Enums\LoggingFieldsEnum;
use Illuminate\Http\JsonResponse;
use Intergo\Log\GrayLogHandler;

trait ResponseTrait
{
    /**
     * @param $data
     * @param string $message
     * @return JsonResponse
     */
    private function success($data = [], string $message = ''): JsonResponse
    {
        return $this->response(true, $message, $data);
    }

    /**
     * @param string $message
     * @param array $data
     * @param int $code
     * @return JsonResponse
     */
    private function failed(string $message = 'Unauthorized', $data = [], int $code = 401)
    {
        return $this->response(false, $message, $data, $code);
    }

    /**
     * @param string $message
     * @param Throwable $exception
     * @param GrayLogHandler|null $grayLogger
     * @param array $data
     * @param ?int $code
     * @return JsonResponse
     */
    private function failedException(string $message, Throwable $exception, GrayLogHandler $grayLogger = null, $data = [], $code = 401)
    {
        if ($grayLogger) {
            $data[LoggingFieldsEnum::EXCEPTION_MESSAGE] = $exception->getMessage();
            $data[LoggingFieldsEnum::EXCEPTION_TRACE] = $exception->getTraceAsString();
            $data[LoggingFieldsEnum::RESPONSE_CODE] = $exception->getCode();
            $data[LoggingFieldsEnum::RESPONSE_STATUS_CODE] = $code;
            $grayLogger->error($message, $data);
        }
        return $this->failed($message, [], $code);
    }

    /**
     * @param bool $success
     * @param string $message
     * @param array $data
     * @param int $status
     * @return JsonResponse
     */
    private function response(bool $success = true, string $message = '', array $data = [], int $status = 200): JsonResponse
    {
        return response()->json(compact('success', 'message', 'data'), $status);
    }
}
