<?php
declare(strict_types=1);

namespace Intergo\LaravelAuthMiddleware\Policies;
use Intergo\LaravelAuthMiddleware\Models\AuthUser;
use Illuminate\Auth\Access\HandlesAuthorization;

class IntergoPolicy
{
    use HandlesAuthorization;

    /**
     * @param AuthUser $user
     * @return bool
     */
    public function intergoEmployeeOnly(AuthUser $user):bool
    {
        return $user->isIntergoEmployee();
    }
}
