<?php
declare(strict_types=1);

namespace Intergo\LaravelAuthMiddleware\Http\Middleware\Web;

use Auth;
use Closure;

class CheckPermissionWeb
{
    /**
     * Handle the incoming request.
     *
     * @param $request
     * @param Closure $next
     * @param string $permission
     * @return mixed|void
     */
    public function handle($request, Closure $next, string $permission)
    {
        $user = Auth::user();
        $permissions = explode('|', $permission);
        if ($user->hasAnyPermission($permissions)) {
            return $next($request);
        }
        abort(403);
    }
}
