<?php

namespace Intergo\LaravelAuthMiddleware\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Intergo\AuthClient\Enums\PermissionEnum;

class AuthUser extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * @param string $permission
     * @return bool
     */
    public function hasPermission(string $permission):bool {
        return in_array($permission, $this->permission);
    }

    /**
     * @return bool
     */
    public function isIntergoEmployee():bool {
        return in_array(PermissionEnum::ACCESS_MANAGER_AREA, $this->permission);
    }
}
