<?php

namespace Intergo\InventoryClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class InventoryApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        //Numbers
        'getNumberSubscriptionDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/numbers/:number/subscription/details', self::INTERNAL => true],

        //Users
        'getUserSubscriptions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions', self::INTERNAL => true],
        'getUserSubscriptionDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions/:subscription_id', self::INTERNAL => true],
        'cancelUserSubscription' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/users/:id/subscriptions/:subscription_id', self::INTERNAL => true],
        'renewUserSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/subscriptions/:subscription_id/renew', self::INTERNAL => true],

        //Callbacks
        'notifyServiceSubscriptionTermination' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/service/termination', self::INTERNAL => true],
        'notifyServiceSubscriptionOnGrace' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/service/grace', self::INTERNAL => true],
        'notifyServiceSubscriptionRenewal' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/service/renewal', self::INTERNAL => true],
        'notifyNumberSubscriptionTermination' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/number/termination', self::INTERNAL => true],
        'notifyNumberSubscriptionOnGrace' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/number/grace', self::INTERNAL => true],
    ];
}
