<?php

namespace Intergo\InventoryClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class InventoryApiHandler extends ApiHandler
{
    protected static $endpoints = [
        //Countries
        'getAllCountries' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/countries'],
        'getCountryCities' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/countries/:code/cities'],
        'getUSStates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/countries/us/states'],
        'getStateCities' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/countries/us/states/:code/cities'],
        'getInventoryAvailableCountries' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/countries/available'],

        //Numbers
        'getNumbersForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/numbers'],
        'getUserRentedNumbers' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/numbers/rented'],
        'getRentedNumberDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/numbers/details'],
        'getRentedNumberDetailsByNumber' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/numbers/details/by-number'],
        'requestNumber' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/:site/numbers/request'],
        'cancelNumberSubscription' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/numbers/subscription/cancel'],
        'updateNumberSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/:site/numbers/settings/update'],

        //Number Types
        'getNumberTypes' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/number-types'],

        //Keywords
        'validateKeyword' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/:site/keywords/validate'],
        'cancelKeywordRequest' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/:site/keywords/request/:request_id/cancel'],

        //Group Plans
        'updateGroupPlanSettings' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/:site/group-plans/settings/update'],

    ];
}
