<?php

namespace Intergo\InventoryClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class InventoryApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        //Numbers
        'getNumberSubscriptionDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/numbers/:number/subscription/details', self::INTERNAL => true],
        'getAvailableNumbersForRenting' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/numbers', self::INTERNAL => true],
        'allocateNumber' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/numbers', self::INTERNAL => true],

        //Users
        'getUserSubscriptions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions', self::INTERNAL => true],
        'getUserSubscriptionDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions/:subscription_id', self::INTERNAL => true],
        'getUserSubscriptionBillingLogDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions/:subscription_id/logs/:log_id', self::INTERNAL => true],
        'cancelUserSubscription' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/users/:id/subscriptions/:subscription_id', self::INTERNAL => true],
        'revertCancelUserSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/subscriptions/:subscription_id/revert', self::INTERNAL => true],
        'renewUserSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/subscriptions/:subscription_id/renew', self::INTERNAL => true],
        'getUserViberSenderIdDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/services/viber/sender-ids', self::INTERNAL => true],
        'getUserViberBalance' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/viber/balance', self::INTERNAL => true],

        //Callbacks
        'subscriptionOnGraceCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/:type/grace', self::INTERNAL => true],
        'subscriptionRenewalCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/:type/renewal', self::INTERNAL => true],
        'subscriptionTerminationCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/:type/termination', self::INTERNAL => true],
        'subscriptionNumberExpiringCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:type/expiring', self::INTERNAL => true],

        //Notifications
        'sendUserInboundSMSReceivedNotification' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/notifications/inbound/sms/received', self::INTERNAL => true],
        'sendUserInboundSMSReceiptNotification' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/notifications/inbound/sms/receipt', self::INTERNAL => true],
        'sendUserOptOutReceiptNotification' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/notifications/inbound/optout/receipt', self::INTERNAL => true],

        //Failed Jobs
        'getFailedJobs' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs', self::INTERNAL => true],
        'getFailedJob' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs/:id', self::INTERNAL => true],
        'getFailedJobsQueues' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs/queues', self::INTERNAL => true],
        'retryFailedJobs' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/retry', self::INTERNAL => true],
        'deleteFailedJobs' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/delete', self::INTERNAL => true],
    ];
}
