<?php

namespace Intergo\InventoryClient\ValueObjects;

class NumberSubscriptionDetailsVO
{
    private array $user;
    private int $subscriptionId;
    private string $number;
    private string $startedAt;
    private array $renewals;
    private int $planId;
    private string $planName;
    private float $setupFee;
    private float $recurringFee;
    private string $planType;
    private string $status;
    private ?bool $canRenew;
    private ?bool $canCancel;
    private float $inboundSMSFee;

    public function getUser(): array
    {
        return $this->user;
    }

    public function setUser(array $user): void
    {
        $this->user = $user;
    }

    public function getSubscriptionId(): int
    {
        return $this->subscriptionId;
    }

    public function setSubscriptionId(int $subscriptionId): void
    {
        $this->subscriptionId = $subscriptionId;
    }

    public function getNumber(): string
    {
        return $this->number;
    }

    public function setNumber(string $number): void
    {
        $this->number = $number;
    }

    public function getStartedAt(): string
    {
        return $this->startedAt;
    }

    public function setStartedAt(string $startedAt): void
    {
        $this->startedAt = $startedAt;
    }

    public function getRenewals(): array
    {
        return $this->renewals;
    }

    public function setRenewals(array $renewals): void
    {
        $this->renewals = $renewals;
    }

    public function getPlanId(): int
    {
        return $this->planId;
    }

    public function setPlanId(int $planId): void
    {
        $this->planId = $planId;
    }

    public function getPlanName(): string
    {
        return $this->planName;
    }

    public function setPlanName(string $planName): void
    {
        $this->planName = $planName;
    }

    public function getSetupFee(): float
    {
        return $this->setupFee;
    }

    public function setSetupFee(float $setupFee): void
    {
        $this->setupFee = $setupFee;
    }

    public function getRecurringFee(): float
    {
        return $this->recurringFee;
    }

    public function setRecurringFee(float $recurringFee): void
    {
        $this->recurringFee = $recurringFee;
    }

    public function getPlanType(): string
    {
        return $this->planType;
    }

    public function setPlanType(string $planType): void
    {
        $this->planType = $planType;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    public function getCanRenew(): ?bool
    {
        return $this->canRenew;
    }

    public function setCanRenew(?bool $canRenew): void
    {
        $this->canRenew = $canRenew;
    }

    public function getCanCancel(): ?bool
    {
        return $this->canCancel;
    }

    public function setCanCancel(?bool $canCancel): void
    {
        $this->canCancel = $canCancel;
    }

    public function getInboundSMSFee(): float
    {
        return $this->inboundSMSFee;
    }

    public function setInboundSMSFee(float $inboundSMSFee): void
    {
        $this->inboundSMSFee = $inboundSMSFee;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return get_object_vars($this);
    }
}
