<?php

namespace Intergo\InventoryClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractInventoryService
{
    private InventoryClient $client;

    /**
     * InventoryService constructor.
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new InventoryClient($baseUrl, $traceId);
    }

    /**
     * @param $endpoint
     * @param array $bodyParams
     * @param array $urlParams
     * @return BaseResponseInterface
     */
    protected function execute($endpoint, array $bodyParams = [], array $urlParams = [])
    {
        $result = $this->client->execute($endpoint, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    /**
     * @param $endpoint
     * @param $token
     * @param array $bodyParams
     * @param array $urlParams
     * @return BaseResponseInterface
     */
    protected function executeAuth($endpoint, $token, array $bodyParams = [], array $urlParams = [])
    {
        $result = $this->client->executeAuth($endpoint, $token, $urlParams, $bodyParams);
        return $this->response($endpoint, $result);
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result);

    /**
     * @param $number
     * @return BaseResponseInterface
     */
    public function getNumberSubscriptionDetails($number)
    {
        return $this->execute(__FUNCTION__, [], compact('number'));
    }
}
