<?php

namespace Intergo\InventoryClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class InventoryApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        //Numbers
        'getNumberSubscriptionDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/numbers/:number/subscription/details', self::INTERNAL => true],

        //Users
        'getUserSubscriptions' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions', self::INTERNAL => true],
        'getUserSubscriptionDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions/:subscription_id', self::INTERNAL => true],
        'getUserSubscriptionBillingLogDetails' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/users/:id/subscriptions/:subscription_id/logs/:log_id', self::INTERNAL => true],
        'cancelUserSubscription' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/users/:id/subscriptions/:subscription_id', self::INTERNAL => true],
        'renewUserSubscription' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/users/:id/subscriptions/:subscription_id/renew', self::INTERNAL => true],

        //Callbacks
        'subscriptionOnGraceCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/:type/grace', self::INTERNAL => true],
        'subscriptionRenewalCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/:type/renewal', self::INTERNAL => true],
        'subscriptionTerminationCallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/callbacks/subscriptions/:id/:type/termination', self::INTERNAL => true],

        //Notifications
        'sendUserInboundSMSReceivedNotification' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/notifications/inbound/sms/received', self::INTERNAL => true],
        'sendUserInboundSMSReceiptNotification' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/notifications/inbound/sms/receipt', self::INTERNAL => true],
        'sendUserOptOutReceiptNotification' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/notifications/inbound/optout/receipt', self::INTERNAL => true],
    ];
}
