# Installation
> composer require intergo/inventory-client


## Usage

```php
<?php

require_once './vendor/autoload.php';

$service = new \Intergo\InventoryClient\InventoryService('inventory', 'https://inventory.local.intergo.co', 'random', 123);
```

### Request Inventory

```php
$userID = 2;
$planID = 2;
$inventoryID = 2;
$keyword = null;
var_dump($service->requestInventory($userID, $planID, $inventoryID, $keyword));
```

### Get All Inventories

```php
var_dump($service->inventories());
```

### Get All Inventory Plans

```php
$inventoryID = 2;
var_dump($service->inventoryPlans($inventoryID));
```

### Get All Subscriptions

```php
var_dump($service->subscriptions());
```

### Renew Subscription

```php
$subscriptionID = 10;
var_dump($service->renew($subscriptionID));
```

### Get All Subscription Renewals

```php
$subscriptionID = 10;
var_dump($service->subscriptionRenewals($subscriptionID));
```

### Cancel Subscription

```php
$subscriptionID = 10;
var_dump($service->cancel($subscriptionID));
```