<?php

namespace Intergo\HlrClient\UI;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class LookupApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        'estimate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/estimate'],
        'lookup' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/lookup'],
        'getPaginatedReports' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/reports'],
        'initializeExport' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/reports/:uuid/initialize-export'],
        'getExports' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/reports/exports'],
        'deleteExport' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/reports/exports/:type/:fileName'],
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings'],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings'],
        'getGlobalSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/global-settings'],
    ];

    protected static string $apiVersion = '/v2';
}