<?php

namespace Intergo\HlrClient\Manager;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class LookupApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        ############################################### REPORTS ###############################################
        'getPaginatedReports' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/reports'],
        ############################################### NUMBER LOOKUPS ###############################################
        'getPaginatedNumberLookups' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/number-lookups'],
        'getUserStats' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/number-lookups/user-stats/:user_id'],
        ############################################### PROVIDERS ###############################################
        'getPaginatedProviders' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/providers'],
        'getAllProviders' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/providers'],
        'getProviderById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/providers/:id'],
        'updateProvider' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/providers/:id'],
        ############################################### PROVIDER-RATES ###############################################
        'getPaginatedProviderRates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/provider-rates'],
        'getProviderRateById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/provider-rates/:id'],
        'storeProviderRate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/provider-rates'],
        'updateProviderRate' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/provider-rates/:id'],
        'destroyProviderRate' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/provider-rates/:id'],
        'importProviderRates' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/provider-rates/import'],
        ############################################### GLOBAL SETTINGS ############################################
        'getGlobalSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/global-settings'],
        'updateGlobalSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/global-settings'],
        'updateLookupDisabled' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/global-settings/lookup_disabled'],
        ############################################### COUNTRY-RATES ############################################
        'getPaginatedCountryRates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/country-rates'],
        'getAllCountryRates' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/country-rates'],
        'getCountryRateById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/country-rates/:id'],
        'storeCountryRate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/country-rates'],
        'updateCountryRate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/country-rates/:id'],
        'destroyCountryRate' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/country-rates/:id'],
        ############################################### USER SETTINGS ############################################
        'getUserSettings' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings/:id'],
        'updateUserSettings' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/user-settings/:id'],
        ############################################### ADJUSTED RATES ############################################
        'getAdjustedRatesForUser' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/user-settings/:user_id/adjusted-rates'],
        'getAdjustedRateById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/adjusted-rates/:id'],
        'storeAdjustedRate' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/user-settings/:user_id/adjusted-rates'],
        'updateAdjustedRate' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/adjusted-rates/:id'],
        'destroyAdjustedRate' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/adjusted-rates/:id'],
        ############################################### FAILED JOBS ############################################
        'getPaginatedFailedJobs' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs'],
        'getFailedQueues' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs/failed-queues'],
        'getFailedJobById' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/failed-jobs/:id'],
        'rerunFailedJob' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/:id/rerun'],
        'destroyFailedJob' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/failed-jobs/:id'],
        'rerunBulk' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/rerun-bulk'],
        'destroyBulk' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/failed-jobs/delete-bulk'],
    ];

    protected static string $apiPrefix = '/manager';
    protected static string $apiVersion = '';

}