<?php

namespace Intergo\Helpers;

class MessageHelper
{

    /**
     * @param $text
     * @return bool
     */
    public static function isGsm7bit($text)
    {
        $gsm7bitChars = "\\\@£\$¥èéùìòÇ\nØø\rÅåΔ_ΦΓΛΩΠΨΣΘΞÆæßÉ !\"#¤%&'()*+,-./0123456789:;<=>?¡ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÑÜ§¿abcdefghijklmnopqrstuvwxyzäöñüà^{}[~]|€";
        $textLength = mb_strlen($text);
        for ($i = 0; $i < $textLength; $i++) {
            if ((strpos($gsm7bitChars, mb_substr($text, $i, 1)) === false) && (mb_substr($text, $i, 1) != "\\")) {
                return false;
            } //strpos not     able to detect \ in string
        }

        return true;
    }

}