<?php
declare(strict_types=1);

use Intergo\Helpers\PasswordGeneratorHelper;
use PHPUnit\Framework\TestCase;

class PasswordGeneratorHelperTest extends TestCase
{
    /**
     * @throws Exception
     */
    public function testCreateNumericPassword()
    {
        $passwordLength = rand(5, 15);
        $password = PasswordGeneratorHelper::numeric($passwordLength);
        $this->assertCount($passwordLength, str_split($password));
        $this->assertIsNumeric($password);
    }

    /**
     * @throws Exception
     */
    public function testCreateAlphaNumericPassword()
    {
        $passwordLength = rand(5, 15);
        $password = PasswordGeneratorHelper::characters($passwordLength);
        $this->assertCount($passwordLength, str_split($password));
        $this->assertMatchesRegularExpression("/^[a-zA-Z0-9]+$/",$password);
    }

    /**
     * @throws Exception
     */
    public function testCreateCharactersPassword()
    {
        $passwordLength = rand(5, 15);
        $password = PasswordGeneratorHelper::characters($passwordLength);
        $this->assertCount($passwordLength, str_split($password));
        $this->assertMatchesRegularExpression("/^[a-zA-Z]+$/",$password);
    }
}