<?php

namespace Intergo\Tests;

use Intergo\Helpers\PhoneHelper;
use Intergo\Helpers\ValueObjects\PhoneNumberVO;
use PHPUnit\Framework\TestCase;

class PhoneHelperTest extends TestCase
{
    protected function setUp(): void
    {
        putenv('SERVICE_PHONE_VALIDATOR_URL=https://localhost:8081');
        parent::setUp();
    }

    public function testValidatePhoneNumber()
    {
        $phoneToTest = 'Enter phone number here';
        $defaultPrefix = 'Enter default prefix here';
        $expectedPhone = 'Enter expected phone number here';

        $isValidPhone = PhoneHelper::validatePhoneNumber($phoneToTest, $defaultPrefix, true);
        $this->assertTrue($isValidPhone);
        $response = PhoneHelper::validatePhoneNumber($phoneToTest, $defaultPrefix, false);
        $this->assertInstanceOf(PhoneNumberVO::class, $response);
        $this->assertEquals($expectedPhone, $response->getPhoneNumber());
    }
}
