<?php

namespace Intergo\Helpers;

class StringHelper
{
    /**
     * @param $haystack
     * @param $needle
     * @return bool
     */
    public static function startsWith($haystack, $needle) {
        return strncmp($haystack, $needle, strlen($needle)) === 0;
    }

    /**
     * @param $haystack
     * @param $needle
     * @return bool
     */
    public static function endsWith($haystack, $needle) {
        return substr_compare($haystack, $needle, -strlen($needle)) === 0;
    }

    /**
     * @param $json
     * @param $delimiter
     * @param $enclosure
     * @param $escape_char
     * @return false|string
     */
    public static function convertJsonToCSV($json, $delimiter = ',', $enclosure = '"', $escape_char = "\\")
    {
        $f = fopen('php://memory', 'r+');
        $colHeader = array_keys($json[0]);
        fputcsv($f, $colHeader, $delimiter, $enclosure, $escape_char);
        foreach ($json as $item) {
            fputcsv($f, $item, $delimiter, $enclosure, $escape_char);
        }
        rewind($f);
        return stream_get_contents($f);
    }

    /**
     * Add single quotes around the specified string.
     *
     * Used when generating SQL strings for inserting (importing) data from .csv files.
     *
     * @param $string
     * @return string
     */
    public static function addSingleQuotes($string)
    {
        if ($string !== 'NULL' && $string !== 'null' && $string !== 'Null') {
            return sprintf("'%s'", $string);
        }
        return $string;
    }

    /**
     * Used to fix the issue when importing CSV files with invalid (non-unicode) characters.
     *
     * @param string $string
     * @return bool|string
     */
    public static function handleInvalidStrings(string $string)
    {
        if ($string !== '') {
            $encoding = mb_detect_encoding($string, 'UTF-8, ISO-8859-1, WINDOWS-1252, WINDOWS-1251', true);
            if ($encoding != 'UTF-8') {
                $string = iconv($encoding, 'UTF-8//IGNORE', $string);
            }
        }
        return $string;
    }

    /**
     * Find the position of the first occurrence of an array of substrings in a string
     *
     * @param string $haystack The string to search in
     * @param array $needles The array of neededls.
     * If any needle is not a string, it is converted to an integer and applied as the ordinal value of a character.
     * @param integer $offset [optional] If specified, search will start this number of characters counted from the beginning of the string.
     * Unlike {@see strrpos()} and {@see strripos()}, the offset cannot be negative.
     * @return integer|false Returns the position where the needle exists relative to the beginnning of the haystack string (independent of search direction or offset). Also note that string positions start at 0, and not 1.
     * Returns FALSE if the needle was not found.
     */
    public static function strpos_in_array(string $haystack, array $needles, int $offset = 0)
    {
        foreach ($needles as $needle ) {
            $position = strpos($haystack, $needle, $offset);
            if ($position !== false) {
                return $position;
            }
        }
        return false;
    }
}