<?php
declare(strict_types=1);

namespace Intergo\Helpers;

/**
 * Password Generator logic has been taken from the below page and transformed to plain php
 * @url https://www.amitmerchant.com/laravel-10-password-generator/
 */
class PasswordGeneratorHelper
{
    public static $letters = [
        'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
        'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
        'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G',
        'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R',
        'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    ];
    public static $numbers = [
        '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
    ];

    public static $symbols = [
        '~', '!', '#', '$', '%', '^', '&', '*', '(', ')', '-',
        '_', '.', ',', '<', '>', '?', '/', '\\', '{', '}', '[',
        ']', '|', ':', ';',
    ];

    /**
     * Generate a password
     * @param int $length - The number of characters
     * @throws \Exception
     */
    public static function create(int $length): string
    {
        return static::password($length, true, true, true);
    }

    /**
     * Generate an alpha numeric password
     * @param int $length - The number of characters
     * @throws \Exception
     */
    public static function alphaNumeric(int $length): string
    {
        return static::password($length, true, true);
    }

    /**
     * Generate a numeric only password
     * @param int $length - The number of characters
     * @throws \Exception
     */
    public static function numeric(int $length): string
    {
        return static::password($length, true);
    }

    /**
     * Generate a characters only password
     * @param int $length - The number of characters
     * @throws \Exception
     */
    public static function characters(int $length): string
    {
        return static::password($length, false, true);
    }

    /**
     * Generate a random, secure password.
     *
     * @param int $length
     * @param bool $hasNumbers
     * @param bool $hasLetters
     * @param bool $hasSymbols
     * @return string
     * @throws \Exception
     */
    public static function password(int $length, bool $hasNumbers = false, bool $hasLetters = false, bool $hasSymbols = false): string
    {
        $availableSymbols = [];
        if ($hasNumbers) {
            $availableSymbols = array_merge($availableSymbols, static::$numbers);
        }
        if ($hasLetters) {
            $availableSymbols = array_merge($availableSymbols, static::$letters);
        }
        if ($hasSymbols) {
            $availableSymbols = array_merge($availableSymbols, static::$symbols);
        }
        $password = '';
        $numberOfAvailableSymbols = count($availableSymbols);
        for ($i = 0; $i < $length; $i++) {
            $indexToAdd = random_int(0, $numberOfAvailableSymbols - 1);
            $password .= $availableSymbols[$indexToAdd];
        }
        return $password;
    }
}