<?php

namespace Intergo\FallbackServiceClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class FallbackServiceHandler extends ApiHandler
{
    protected static array $endpoints = [
        'storeFallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/fallback', self::INTERNAL => true],
        'updateFallback' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/fallback/update', self::INTERNAL => true],
        'storeOTPFallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/otp-fallback', self::INTERNAL => true],
        'deleteFallback' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/fallback', self::INTERNAL => true],
        'consumeFallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/fallback/consume', self::INTERNAL => true],
        'deleteOTPFallback' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/otp-fallback', self::INTERNAL => true],
        'consumeOTPFallback' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/otp-fallback/consume', self::INTERNAL => true],
    ];
}
