<?php

namespace Intergo\FallbackServiceClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class AbstractFallbackService
{
    private FallbackServiceClient $client;

    /**
     * ViberApiService constructor.
     *
     * @param string $baseUrl
     * @param string $traceId
     */
    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new FallbackServiceClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param $tracking_id
     * @param $expires_at
     * @param $payload
     * @return BaseResponseInterface
     */
    public function storeFallback($tracking_id, $expires_at, $payload): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('tracking_id', 'expires_at', 'payload'));
    }

    /**
     * Deletes a fallback by tracking id
     *
     * @param $tracking_id
     * @return BaseResponseInterface
     */
    public function deleteFallback($tracking_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('tracking_id'));
    }

    /**
     * @param $tracking_id
     * @return BaseResponseInterface
     */
    public function consumeFallback($tracking_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('tracking_id'));
    }

    /**
     * @param $tracking_id
     * @param $expires_at
     * @param $payload
     * @return BaseResponseInterface
     */
    public function storeOTPFallback($tracking_id, $expires_at, $payload): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('tracking_id', 'expires_at', 'payload'));
    }

    /**
     * Deletes an otp fallback by tracking id
     *
     * @param $tracking_id
     * @return BaseResponseInterface
     */
    public function deleteOTPFallback($tracking_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('tracking_id'));
    }

    /**
     * @param $tracking_id
     * @return BaseResponseInterface
     */
    public function consumeOTPFallback($tracking_id): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], compact('tracking_id'));
    }
}
