<?php

namespace Intergo\CrmApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class CrmApiService
{
    /**
     * List of possible CRMs.
     */
    const SALESFORCE = 'Salesforce';

    /**
     * List of possible CRM entities.
     */
    const LEAD = 'Lead';
    const ACCOUNT = 'Account';
    const CONTACT = 'Contact';

    /**
     * List of possible CRM entity statuses.
     */
    const OPEN = 'Open';
    const WORKING_QUALIFIED = 'Working - Qualified';
    const UNQUALIFIED_BANNED = 'Unqualified and Banned';

    /**
     * List of possible CRM lead sources.
     */
    const WEB_FORM = 'Web Form';
    const WIDGET = 'Widget';

    /**
     * List of possible CRM record types.
     */
    const SMB = 'SMB';
    const ENTERPRISE = 'ENTERPRISE';

    /**
     * List of possible CRM product types.
     */
    const SMS = 'SMS';
    const VOICE = 'Voice';

    private CrmApiClient $client;

    /**
     * CrmApiService constructor.
     *
     * @param string $baseUrl
     * @param string $traceId
     */
    public function __construct(string $baseUrl, string $traceId)
    {
        $this->client = new CrmApiClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param array $entityData
     * @return BaseResponseInterface
     */
    public function createEntity(array $entityData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $entityData);
    }

    /**
     * @param array $userData
     * @return BaseResponseInterface
     */
    public function createAccountContact(array $userData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userData);
    }

    /**
     * @param array $entityData
     * @return BaseResponseInterface
     */
    public function updateEntity(array $entityData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $entityData);
    }

    /**
     * @param array $entityData
     * @return BaseResponseInterface
     */
    public function deleteEntity(array $entityData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $entityData);
    }

    /**
     * @param array $entityData
     * @return BaseResponseInterface
     */
    public function searchEntity(array $entityData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $entityData);
    }

    /**
     * @param array $entityData
     * @return BaseResponseInterface
     */
    public function convertLead(array $entityData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $entityData);
    }

    /**
     * @param array $userData
     * @return BaseResponseInterface
     */
    public function userEntitiesList(array $userData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userData);
    }

    /**
     * @param array $userData
     * @return BaseResponseInterface
     */
    public function createLeadFromWidget(array $userData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userData);
    }

    /**
     * @param array $userData
     * @return BaseResponseInterface
     */
    public function notifySalesforceAboutPayment(array $userData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userData);
    }

    /**
     * @param array $userData
     * @return BaseResponseInterface
     */
    public function notifySalesforceAboutBan(array $userData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $userData);
    }
}
