<?php

namespace Intergo\CrmApiClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class CrmApiHandler extends ApiHandler
{
    protected static array $endpoints = [
        ############################################### ENTITIES ###############################################
        'createEntity' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/create', self::INTERNAL => true],
        'createAccountContact' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/create/account/contact', self::INTERNAL => true],
        'updateEntity' => [self::METHOD => HttpMethodEnum::PUT, self::URL => '/entities/update', self::INTERNAL => true],
        'deleteEntity' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/entities/delete', self::INTERNAL => true],
        'searchEntity' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/search', self::INTERNAL => true],
        'convertLead' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/convert/lead', self::INTERNAL => true],
        'userEntitiesList' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/entities/user/list', self::INTERNAL => true],
        'createLeadFromWidget' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/widget/create/lead', self::INTERNAL => true],
        'notifySalesforceAboutPayment' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/user/payment', self::INTERNAL => true],
        'notifySalesforceAboutBan' => [self::METHOD => HttpMethodEnum::POST, self::URL => '/entities/user/banned', self::INTERNAL => true],
    ];
}
