<?php

namespace Intergo\CrmApiClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;

abstract class CrmApiService
{
    private CrmApiClient $client;

    /**
     * CrmApiService constructor.
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new CrmApiClient($baseUrl, $traceId);
    }

    /**
     * @param string $endpoint
     * @param array $urlParams
     * @param array $bodyParams
     * @return BaseResponseInterface
     */
    protected function execute(string $endpoint, array $urlParams = [], array $bodyParams = []): BaseResponseInterface
    {
        return $this->response($endpoint, $this->client->execute($endpoint, $urlParams, $bodyParams));
    }

    /**
     * @param string $action
     * @param BaseResponseInterface $result
     * @return BaseResponseInterface
     */
    abstract public function response(string $action, BaseResponseInterface $result): BaseResponseInterface;

    /**
     * @param array $entityData
     * @return BaseResponseInterface
     */
    public function createEntity(array $entityData): BaseResponseInterface
    {
        return $this->execute(__FUNCTION__, [], $entityData);
    }
}