<?php

namespace Intergo\CountryRegulationsClient;

use Intergo\BaseClient\ApiHandler;
use Intergo\BaseClient\Enums\HttpMethodEnum;

class CountryRegulationsHandler extends ApiHandler
{

    protected static array $endpoints = [
        'getAllCountryRegulations' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/', self::INTERNAL => true ],
        'createCountryRegulation' => [ self::METHOD => HttpMethodEnum::POST, self::URL => '/', self::INTERNAL => true ],
        'getCountryRegulationById' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/:id', self::INTERNAL => true ],
        'updateCountryRegulation' => [ self::METHOD => HttpMethodEnum::PUT, self::URL => '/:id', self::INTERNAL => true ],
        'deleteCountryRegulation' => [ self::METHOD => HttpMethodEnum::DELETE,  self::URL => '/:id', self::INTERNAL => true ],
        'getCountryRegulations' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/:country_code', self::INTERNAL => true ],
        'getCountryRegulationTypes' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/types', self::INTERNAL => true ],
        'getRegistrationRequirements' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/registration-requirements', self::INTERNAL => true ],
        'getNetworkProviders' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/network-providers', self::INTERNAL => true ],
        'getFeesByCountryCode' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/:country_code/fees', self::INTERNAL => true ],
        'getTrafficType' => [ self::METHOD => HttpMethodEnum::GET, self::URL => '/traffic-types', self::INTERNAL => true ],
        'getDocumentPaths' => [self::METHOD => HttpMethodEnum::GET, self::URL => '/documents/:id', self::INTERNAL => true],
        'deleteDocument' => [self::METHOD => HttpMethodEnum::DELETE, self::URL => '/documents/:id', self::INTERNAL => true]
    ];
}