<?php

namespace Intergo\CountryRegulationsClient;

use Intergo\BaseClient\Responses\BaseResponseInterface;
use Intergo\CountryRegulationsClient\CountryRegulationsClient;

class AbstractCountryRegulationsService {
    protected CountryRegulationsClient $client;

    /**
     * AbstractSubscriptionService constructor.
     * https://intergo.atlassian.net/wiki/spaces/ES/pages/2149187587/Communication+between+microservices
     *
     * @param $baseUrl
     * @param $traceId
     */
    public function __construct($baseUrl, $traceId)
    {
        $this->client = new CountryRegulationsClient($baseUrl, $traceId);
    }

    /**
     * @param $attributes
     * @return  BaseResponseInterface
     */
    public function createCountryRegulation($attributes)
    {
        extract($attributes);
        unset($attributes);
        return $this->execute(__FUNCTION__, get_defined_vars());
    }

}