<?php

namespace Intergo\CommonSending\DataTransferObjects\Messages\Single;

use Intergo\CommonSending\Enums\ChannelEnum;
use Intergo\CommonSending\Enums\ProductClassificationEnum;
use Intergo\CommonSending\Enums\ViberType;
use Intergo\CommonSending\Traits\HasFullViberFields;

class ViberMessageDTO extends AbstractSingleMessageDTO
{
    use HasFullViberFields;

    /**
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->messageDTO = new MessageDTO($data);
        parent::__construct($data);

        //scheduled viber message is not supported for the initial release
        $this->messageDTO->scheduled_for = null;

        $this->messageDTO->channel = ChannelEnum::VIBER;
        if ($this->viber_type == ViberType::TRANSACTIONAL_TEXT || $this->viber_type == ViberType::TRANSACTIONAL_TEXT_TWO_WAY) {
            $this->messageDTO->product_classification = ProductClassificationEnum::TRANSACTIONAL;
        } else {
            $this->messageDTO->product_classification = ProductClassificationEnum::MARKETING;
        }
    }
}
